/* PROGRAM R.Tutor (a tutorial for writing applications using resources)  */
/* Part 1 - starting up & shutting down the tools from a ToolStartup List */
/*          The list is kept in a resource */


#include <types.h>     /* most common stuff */
#include <INTMATH.h>   /* HiWord & LoWord come from here */
#include <MEMORY.h>    /* used by MMStartUp call */
#include <MISCTOOL.h>  /* SysBeep lives here */
#include <LOCATOR.h>   /* StartupTools and ShutDownTools come from here */


#define kStartStopID 1L  /* define constant for resource ID of StartStop list */



/* declare all of the global variables that we'll be using */
unsigned gMyMemID;      /* holds the ID returned by MMStartup */
Ref      gToolListRef;  /* the list of tools used to start and stop the tools */
Boolean  gPunt;         /* TRUE if it's time to quit the app */


/* ------------------------------------------------------------------------- */
/* the following procedure is responsible for starting the tools (using the  */
/* list in a resource) if the SartupTools call fails, then gPunt will        */
/* contain "TRUE", so we can abort the app the global variable for this      */
/* app's memory ID is acquired here as well.                                 */

do_init_rom() /* on the GS, start up the tools here */
{
 /* note, APW C's start.root file automatically buffers _ownerid for us, so  */
 /* we can just grab it from there.  other languages may not do this, so you */
 /* would have to replace the right-hand side of the line below with a call  */
 /* to the memory manager (namely:  MMStartUp) to get your ID.               */
 gMyMemID = _ownerid; /* find out what our memory id is & save it for later  */

 /* pay cloase attention!!!  Make sure kStartStopID is a long!!  Otherwise,  */
 /* only a WORD will be pushed on the stack and the StartUpTools call will   */
 /* fail! */
 gToolListRef = StartUpTools(gMyMemID,refIsResource,kStartStopID);

 if (_toolErr == noError)
  {
   gPunt = FALSE; /* if there was no error, the app can continue starting up */
  }
  else
  {
  gPunt = TRUE; /* something went wrong, so set gPunt to indicate the failure */
   }
}



/* ------------------------------------------------------------------------- */
/* the following procedure is the main application itself. */

main()
{
 do_init_rom(); /* get my memory id, start the tools, and set gPunt */
 if (gPunt == FALSE)
   {
  SysBeep(); /* if tools started up ok, then beep three times and shut down */
  SysBeep();
  SysBeep();
   }
 ShutDownTools(refIsHandle,gToolListRef); /* shut down the tools & quit */
} /* end of main program */
